﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="QuotationPOS.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.POS.QuotationPOS" %>

<%@ Register Assembly="CKEditor.NET" Namespace="CKEditor.NET" TagPrefix="CKEditor" %>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>F &amp; B Point of Sale System</title>

    <!-- Bootstrap core CSS -->
    <link href="http://netdna.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css" rel="stylesheet">
    <link href="../Styles/POS/bootstrap.min.css" rel="stylesheet">
    <link href="../Styles/POS/POS-styles.css" rel="stylesheet">
    <link href="../Styles/POS/FlatButtons.css" rel="stylesheet">

    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    <script>
        function OpenPopUp(url) {
            var win = window.open(url, '_blank');
            win.focus();
        }
        function ShowAlert(msg, title) {
            $('#divMessage h4.modal-title').text(title);
            $('#divMessage div.modal-body').html(msg);
            $('#divMessage').modal();
        }

        function OpenSuccessPopup() {
            $('#divOrderSuccess').modal({ keyboard: false, backdrop: 'static', show: 'true' });
        }
        var DefaultView = 'Grid';
    </script>
</head>

<body>
    <form runat="server">
        <asp:ScriptManager runat="server" ID="smDefault">
            <Services>
                <asp:ServiceReference Path="~/Admin/WebService/AzvicService.asmx" />
            </Services>
        </asp:ScriptManager>
        <asp:HiddenField ID="hdnTableName" runat="server" />
        <asp:HiddenField ID="hdProductID" runat="server" />
        <asp:HiddenField ID="hdnProductSize" runat="server" />
        <asp:HiddenField ID="hdnIsHappyHour" runat="server" />

        <!-- Fixed navbar -->
        <div class="navbar navbar-default navbar-fixed-top" role="navigation">
            <div class="container">
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target=".navbar-collapse">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <a class="navbar-brand" href="#">
                        <img src="../Images/logo-small.jpg" width="20" style="margin-right: 5px;" />Ei8ht POS</a>
                </div>
                <div class="navbar-collapse collapse">

                    <ul class="nav navbar-nav navbar-right">

                        <li class="active"><a href="../Dashboard.aspx">Home</a></li>
                    </ul>
                </div>
                <!--/.nav-collapse -->
            </div>
        </div>
        <div class="container">
            <!-- Main component for a primary marketing message or call to action -->
            <div class="jumbotron">
                <div class="row" runat="server" visible="false" id="divNotification">
                    <div class="alert alert-info alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                        <asp:Literal runat="server" ID="lblNotification" />
                    </div>
                </div>
                <%--For Filters--%>
                <div class="row">
                    <div class="col-sm-12 col-md-12 col-xs-12">
                        <input type="button" id="btnCategoryAll" value="All" onclick="ShowAll();" style="padding-left: 15px; padding-right: 15px;" class="alizarin-flat-button" />
                        <asp:Repeater runat="server" ID="rpCategories">
                            <ItemTemplate>
                                <input type="button" id="btnCategory" value="<%# Eval("CategoryName")%>" onclick="<%# "LoadItems('" + Eval("UniqueID") + "');"%>" class="alizarin-flat-button" />
                            </ItemTemplate>
                        </asp:Repeater>
                    </div>
                </div>
                <br />
                <!-- For Contents -->
                <div class="row">

                    <%--For Left Contents--%>
                    <div class="col-lg-5 col-md-5 col-sm-5 col-xs-12">
                        <div class="row pos-sort-row">
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 text-left">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                        View <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a onclick="ShowList(true);" href="#">List</a></li>
                                        <li><a onclick="ShowList(false);" href="#">Grid</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 text-right ">
                                <div class="input-group">
                                    <asp:TextBox runat="server" ID="txtSearch" CssClass="form-control" onkeyup="SearchProduct();" Style="padding: 0px 5px;" />
                                    <span class="input-group-addon fa fa-times-circle fa-inverse anchor" style="color: black" onclick="ClearSearch();"></span>
                                </div>


                            </div>

                        </div>
                        <div class="product-envelope pos-product-list" style="display: none;">
                            <div class="row">
                                <asp:Repeater runat="server" ID="rpProducts">
                                    <ItemTemplate>
                                        <div class="col-md-6 col-xs-12 col-sm-6 col-lg-6 products-row">
                                            <a data-category='<%#Eval("ProductCategoryID")%>' onclick='AddProduct("<%# Eval("UniqueID") %>")'
                                                style="width: 100%; height: 100%; text-decoration: none;">
                                                <div class="pos-product" title='<%#Eval("ProductName").ToString() %>' align="center" valign="middle">
                                                    <span style="display: inline-block; vertical-align: middle; line-height: normal;"><%#Eval("ProductName").ToString() %></span>
                                                </div>
                                            </a>
                                        </div>
                                    </ItemTemplate>
                                </asp:Repeater>
                            </div>
                        </div>

                        <div class="product-envelope pos-product-grid">
                            <div class="row">
                                <asp:Repeater runat="server" ID="rpProductsGrid">
                                    <ItemTemplate>
                                        <div class="col-md-4 col-xs-6 col-sm-4 col-lg-4 products-grid-row">
                                            <a data-category='<%#Eval("ProductCategoryID")%>' onclick='AddProduct("<%# Eval("UniqueID") %>")'
                                                style="width: 100%; height: 100%; text-decoration: none;" class="anchor">
                                                <div class="pos-product" title='<%#Eval("ProductName").ToString() %>' align="center" valign="middle">
                                                    <img src='<%#string.Format("/Images/ProductsImages/{0}",(string.IsNullOrEmpty(Eval("Image1").ToString()) ? "No-Image1.png":Eval("Image1"))) %>'
                                                        style="width: 100%; height: 100%;" />
                                                    <span style="display: inline-block; vertical-align: middle; line-height: normal;" class="product-desc"><%#Eval("ProductName").ToString() %></span>
                                                </div>
                                            </a>
                                        </div>
                                    </ItemTemplate>
                                </asp:Repeater>
                            </div>
                        </div>
                        <br />
                    </div>
                    <%--For Right contents - Cart--%>
                    <div class="col-lg-7 col-md-7 col-sm-7 col-xs-12">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="color: black;font-family:'Open Sans';">
                                <div class="row">
                                    <div class="col-md-6 col-xs-12 text-left">
                                        <strong>Table : </strong>
                                        <asp:Label runat="server" ID="lblTableName" />
                                    </div>
                                    <div class="col-md-6 col-xs-12 text-right">
                                        <strong>Customer : </strong>
                                        <asp:Label runat="server" ID="lblCustomerName" />
                                    </div>
                                </div>
                                <br />
                                <div class="table-responsive">
                                    <table class="table" id="ShoppingCartTable">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th>Qty</th>
                                                <th>Price</th>
                                                <th>Total</th>
                                                <th>Delete</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <br />
                        <div class="row products-totals">
                            <div class="col-md-4 col-sm-4 col-xs-12 pull-left product-order-total">
                                <div class="row">
                                    <div class="col-md-12"><span id="lblNumberofItems"></span>&nbsp; item(s)</div>
                                </div>
                                <br />
                                <div class="row">
                                    <div class="col-md-12">
                                        <asp:LinkButton ID="lnkAddCustomer" runat="server" OnClick="lnkAddCustomer_Click" CssClass="green-sea-flat-button" Text="Customer" />
                                    </div>
                                </div>
                                <br />
                                <div class="row">
                                    <div class="col-md-12">
                                        <%--<asp:LinkButton ID="lnkSettings" runat="server" OnClick="lnkSettings_Click" CssClass="green-sea-flat-button" Text="Settings" />--%>
                                        <a href="../Settings/Settings.aspx" class="green-sea-flat-button">Settings</a>
                                    </div>
                                </div>

                            </div>
                            <div class="col-md-8 col-sm-8 col-xs-12 pull-right">
                                <div class="row products-total-row">
                                    <div class="col-md-6">
                                        Sub Total
                                    </div>
                                    <div class="col-md-6 text-right">
                                        <span id="lblSubTotal"></span>
                                    </div>

                                </div>
                                <div class="row products-total-row">
                                    <div class="col-md-6">
                                        Discounts
                                    </div>
                                    <div class="col-md-6 text-right">
                                        <span id="lblDiscount"></span>
                                    </div>

                                </div>
                                <%--<div class="row products-total-row">
                                    <div class="col-md-6">
                                        Total Before GST
                                    </div>
                                    <div class="col-md-6 text-right">
                                        <span id="lblTotalBeforeGST"></span>
                                    </div>

                                </div>--%>
                                <div class="row products-total-row">
                                    <div class="col-md-6">
                                        Taxes
                                    </div>
                                    <div class="col-md-6 text-right">
                                        <span id="lblTax"></span>
                                    </div>

                                </div>
                                <div class="row products-total-row">
                                    <div class="col-md-6">
                                        Total
                                    </div>
                                    <div class="col-md-6 text-right">
                                        <span id="lblTotal"></span>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <br />
                        <div class="row">
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <a runat="server" ID="btnApplyGST" onserverclick="btnApplyGST_Click" class="clouds-flat-button" style="padding-left:20px;padding-right:20px;">Apply GST</a>
                            </div>
                            <br class="visible-xs visible-sm" />
                            <br class="visible-xs visible-sm" />
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <a class="clouds-flat-button" id="lnkApplyTrxDiscount" runat="server" onserverclick="btnDiscount_Click">Discount</a>
                            </div>
                            <br class="visible-xs visible-sm" />
                            <br class="visible-xs visible-sm" />
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <a class="clouds-flat-button" runat="server" id="lnkSelectTable" onclick="ShowSelectTable();">Table</a>
                            </div>
                            <br class="visible-xs visible-sm" />
                            <br class="visible-xs visible-sm" />
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <a class="clouds-flat-button" runat="server" id="lnkPrintToKitchen" onserverclick="lnkPrintToKitchen_ServerClick">Send to Kitchen</a>
                            </div>
                            <br class="visible-xs visible-sm" />
                            <br class="visible-xs visible-sm" />
                        </div>
                        <br />
                        <%--<div class="row">
                            <div class="col-md-12 col-sm-12 col-xs-12" style="color:white">
                                Remarks
                                <asp:TextBox ID="txtRemarks" runat="server" TextMode="MultiLine" Height="100px" CssClass="form-control" />
                            </div>
                        </div>--%>
                        <br />
                        <div class="row">
                            <div class="col-md-4 col-sm-4 col-xs-12">
                            </div>
                            <div class="col-md-4 col-sm-4 col-xs-12">
                            </div>
                            <div class="col-md-4 col-sm-4 col-xs-12">
                                <%--<asp:LinkButton ID="lnkPreviewQuote" runat="server" OnClick="lnkPreviewQuote_Click" Font-Underline="false" Font-Bold="true" Font-Size="18px" CssClass="btn btn-sky" Text="Preview Quotation" />--%>
                            </div>
                        </div>
                        <br />
                        <br />
                        <div class="row">
                            <div class="col-md-4 col-sm-4 col-xs-12 text-left">
                                <%--<asp:LinkButton ID="lnkPay" runat="server" OnClick="lnkPay_Click" Font-Underline="false" Font-Bold="true" Font-Size="18px" CssClass="btn btn-sky" Text="Make Invoice" />--%>
                                <asp:LinkButton ID="lnkVoidTransaction" runat="server" OnClick="lnkVoidTransaction_Click" CssClass="pomegranate-flat-button" Text="Void Transaction" />
                            </div>
                            <div class="col-md-4 col-sm-4 col-xs-12 text-left">
                                <asp:LinkButton runat="server" ID="btnSavePendingTransaction" Text="Save as Pending" CssClass="belize-hole-flat-button" OnClick="btnSavePendingTransaction_Click" />
                                </div>
                            <div class="col-md-4 col-sm-4 col-xs-12 text-right">
                                <%--<asp:LinkButton ID="LinkButton1" runat="server" OnClick="lnkQuotation_Click" Font-Underline="false" Font-Bold="true" Font-Size="18px" CssClass="btn btn-sky" Text="Make Quotation" />--%>
                                <asp:LinkButton ID="lnkSettle" runat="server" OnClick="lnkSettle_Click" CssClass="belize-hole-flat-button" Text="Settle" />
                            </div>
                        </div>
                        <br />
                        <br />
                    </div>

                </div>
            </div>
        </div>


        <div class="modal fade" id="divPayment" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="H1">Payment</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row pos-receipt-envelope">
                            <table class="table borderless text-center pos-table">
                                <tr>
                                    <td align="center">
                                        <img src="../Images/customer_logo.jpg" width="64" /></td>
                                </tr>
                                <tr>
                                    <td><strong class="pos-receipt-heading">ELEVEN &amp; O PTE LTD</strong><br />
                                        <span class="pos-receipt-address">110 Mackenzie Road, Singapore - 228708</span></td>
                                </tr>
                                <tr>
                                    <td><strong class="pos-receipt-receipt">RECEIPT</strong></td>
                                </tr>
                                <tr>
                                    <td>
                                        <hr class="pos-receipt-divider" />
                                        <table class="table borderless text-left pos-table">
                                            <tr>
                                                <td>Cashier</td>
                                                <td>
                                                    <asp:Literal runat="server" ID="lblReceiptCashier" /></td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td>Date</td>
                                                <td><%= DateTime.Now.ToShortDateString() %></td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td>Time</td>
                                                <td><%= DateTime.Now.ToString("hh:MM ss tt") %></td>
                                                <td></td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <hr class="pos-receipt-divider" />
                                        <table class="table borderless text-left pos-table">
                                            <tr>
                                                <td>Cust.Name</td>
                                                <td>
                                                    <asp:Literal runat="server" ID="lblReceiptCustName" /></td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td>Receipt #</td>
                                                <td>
                                                    <asp:Literal runat="server" ID="lblReceiptNo" /></td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td>Table #</td>
                                                <td>
                                                    <asp:Literal runat="server" ID="lblReceiptTableNumber" /></td>
                                                <td></td>
                                            </tr>
                                        </table>
                                        <hr class="pos-receipt-divider" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <table class="table borderless text-left pos-table">
                                            <tr>
                                                <td>Item</td>
                                                <td>Qty</td>
                                                <td>Price</td>
                                                <td>Total</td>
                                            </tr>
                                            <tr>
                                                <td colspan="4">
                                                    <hr class="pos-receipt-divider" />
                                                </td>
                                            </tr>
                                            <asp:Repeater ID="rptProductsReceipt" runat="server">
                                                <ItemTemplate>
                                                    <tr>
                                                        <td class="text-left">
                                                            <%# Eval("ProductName") %>
                                                        </td>
                                                        <td class="text-center">
                                                            <%# Eval("Quantity") %>
                                                        </td>
                                                        <td class="text-right">
                                                            <%# Eval("UnitPrice") %>
                                                        </td>
                                                        <td class="text-right">
                                                            <%# Eval("Amount") %>
                                                        </td>
                                                    </tr>
                                                </ItemTemplate>
                                            </asp:Repeater>
                                            <tr>
                                                <td colspan="4">
                                                    <hr class="pos-receipt-divider" />
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <table class="table borderless pos-table text-right">
                                            <tr>
                                                <td></td>
                                                <td colspan="2">
                                                    <span>SubTotal<br />
                                                    </span>
                                                    <span id="lblReceiptItemDiscount" runat="server">Item Discount<br />
                                                    </span>
                                                    <span id="lblReceiptTotalDisc" runat="server">Total Discount<br />
                                                    </span>
                                                    <span>Service Charge<br />
                                                    </span>
                                                    <span id="lblReceiptTaxOthers" runat="server">Other Taxes<br />
                                                    </span>
                                                    <span>Total<br />
                                                    </span>
                                                </td>
                                                <td colspan="2">
                                                    <asp:Literal runat="server" ID="lblReceiptSubtotalVal"></asp:Literal>
                                                    <asp:Literal ID="lblReceiptItemDiscountVal" runat="server"></asp:Literal>
                                                    <asp:Literal ID="lblReceiptTotalDiscVal" runat="server"></asp:Literal>
                                                    <asp:Literal ID="lblReceiptSrvChrgeVal" runat="server"></asp:Literal>
                                                    <asp:Literal ID="lblReceiptTaxOthersVal" runat="server"></asp:Literal>
                                                    <asp:Literal ID="lblReceiptTotalVal" runat="server"></asp:Literal>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <center>Thank you and visit again!</center>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-md-12">
                                <asp:Label ID="lblPayError" ForeColor="Red" runat="server" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-md-3 col-sm-3 ">Pay Method : </div>
                            <div class="col-xs-12 col-md-9">
                                <asp:DropDownList ID="ddlPayMethod" runat="server" CssClass="listbox" Width="150px">
                                    <asp:ListItem Selected="true" Value="0" Text="-- Please Select --" />
                                    <asp:ListItem Value="Cash" Text="Cash" />
                                    <asp:ListItem Value="Card" Text="Card" />
                                </asp:DropDownList>
                            </div>
                        </div>
                        <br />
                        <div class="row">
                            <div class="col-xs-12 col-md-3 col-sm-3 ">Amount :</div>
                            <div class="col-xs-12 col-md-9 col-sm-9">
                                <asp:Label runat="server" ID="lblPayTotal" CssClass="adminlabel" />
                            </div>
                        </div>
                        <br />
                        <div class="row">
                            <div class="col-xs-12 col-md-3 col-sm-3 ">Paid Amount :</div>
                            <div class="col-xs-12 col-md-9 col-sm-9">
                                <asp:TextBox runat="server" ID="txtPaidAmount" onkeypress="return isDecimal(event);" onblur="UpdateBalance();" CssClass="textbox number" MaxLength="10" Width="80px" />
                            </div>
                        </div>
                        <br />
                       <div class="row">
                            <div class="col-xs-12 col-md-3 col-sm-3 ">Balance :</div>
                            <div class="col-xs-12 col-md-9 col-sm-9">
                                <h4 id="lblBalanceAmount" />
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <asp:Button ID="btnSaveOrder" runat="server" CssClass="btn btn-primary loading" Text="Confirm Payment"
                            OnClick="btnSaveOrder_Click" />
                        <asp:Button ID="Button3" runat="server" CssClass="btn btn-danger loading" Text="Cancel" data-dismiss="modal" />

                    </div>

                </div>
            </div>
        </div>

        <div class="modal fade" id="divSelectTax" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="H7">Select Tax</h4>
                    </div>
                    <div class="modal-body">
                        <asp:GridView ID="gvTax" CssClass="table" AutoGenerateColumns="false" runat="server" DataKeyNames="TaxID" OnDataBound="gvTax_DataBound">
                            <Columns>
                                <asp:TemplateField HeaderText="Apply Tax">
                                    <ItemTemplate>
                                        <asp:CheckBox runat="server" Checked='<%# Eval("ApplyTaxAsDefault") %>' Enabled='<%# Eval("TaxName").ToString().ToLower().Equals("service charge")?false:true %>' ID="chkSelectTax" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField HeaderText="Name" DataField="TaxName" />
                                <asp:BoundField HeaderText="Type" DataField="TaxType" />
                                <asp:BoundField HeaderText="Value" DataField="TaxValue" />
                            </Columns>
                            <EmptyDataTemplate>
                                No additional Taxes found. Please add in settings if you want to apply any new tax.
                            </EmptyDataTemplate>
                        </asp:GridView>
                        <br />
                        <input type="button" id="btnApplyTax" class="clouds-flat-button" value="Accept" runat="server" onserverclick="lnkSelectTax_ServerClick" />
                        &nbsp;&nbsp;
                        <asp:Button runat="server" ID="btnCancelTax" Text="Reset" CssClass="clouds-flat-button" OnClick="btnCancelTax_Click" />
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="divSelectSize" tabindex="-1" role="dialog" aria-labelledby="Select Size" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="H9">Select Product size</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <asp:Repeater runat="server" ID="rpProductSize">
                                <ItemTemplate>
                                    <div class="col-md-3 col-sm-3 col-xs-12 pos-table-select">
                                        <asp:Button runat="server" data-SizeID='<%# Eval("UniqueID") %>' Text='<%# Eval("MeasurementName") %>' CssClass="alizarin-flat-button" ID="btnSizeSelect" OnClick="btnSizeSelect_Click"></asp:Button>
                                    </div>
                                </ItemTemplate>
                            </asp:Repeater>
                            <asp:Button runat="server" ID="btnOpenSelectSize" OnClick="btnOpenSelectSize_Click" CssClass="dnone" />
                        </div>
                        <br />
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="divSelectTable" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="H8">Select Table</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <asp:Repeater runat="server" ID="rpTables">
                                <ItemTemplate>
                                    <div class="col-md-3 col-sm-3 col-xs-12 pos-table-select">
                                        <asp:Button runat="server" data-TableID='<%# Eval("TableID") %>' Text='<%# Eval("TableName") %>' CssClass="alizarin-flat-button" ID="btnTableSelect" OnClick="btnTableSelect_Click"></asp:Button>
                                    </div>
                                </ItemTemplate>
                            </asp:Repeater>
                        </div>
                        <br />
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="divProduct" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="H2">Product</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-xs-12 col-md-12">
                                <asp:Label ID="lblPError" ForeColor="Red" runat="server" />
                            </div>
                        </div>
                        <br />
                        <%--<div class="row">
                            <div class="col-xs-12 col-md-3 col-sm-3 ">Qty</div>
                            <div class="col-xs-12 col-md-9 col-sm-9">
                                <asp:TextBox runat="server" ID="txtQty" CssClass="textbox number" MaxLength="6" Width="80px" />
                            </div>
                        </div>--%>

                        <div class="row">
                            <div class="col-xs-12 col-md-3 col-sm-3 ">Price</div>
                            <div class="col-xs-12 col-md-9 col-sm-9">
                                <asp:TextBox runat="server" ID="txtPrice" CssClass="textbox number" Width="80px" />
                            </div>
                        </div>
                        <br />
                        <div class="row">
                            <div class="col-xs-12 col-md-3 col-sm-3 ">Discount Type</div>
                            <div class="col-xs-12 col-md-9 col-sm-9">
                                <%--<asp:TextBox runat="server" ID="TextBox1" CssClass="textbox number" Width="80px" />--%>
                                <asp:DropDownList runat="server" ID="ddlProductDiscType">
                                    <asp:ListItem Value="Dollar">Dollar</asp:ListItem>
                                    <asp:ListItem Value="Percentage">Percentage</asp:ListItem>
                                </asp:DropDownList>
                            </div>
                        </div>
                        <br />
                        <div class="row">
                            <div class="col-xs-12 col-md-3 col-sm-3 ">Discount Value</div>
                            <div class="col-xs-12 col-md-9 col-sm-9">
                                <asp:TextBox runat="server" ID="txtDiscount" CssClass="textbox number" Width="80px" />
                            </div>
                        </div>
                        <br />

                        <%--<div class="row">
                            <div class="col-xs-12 col-md-3 col-sm-3 ">Descriptions</div>
                            <div class="col-xs-12 col-md-9 col-sm-9">
                                <CKEditor:CKEditorControl runat="server" ID="txtProductDescriptions" Height="200"
                                    ClientIDMode="Static" BasePath="~/Admin/Scripts/ckeditor" />
                            </div>
                        </div>--%>
                        <br />
                        <div class="modal-footer">
                            <asp:Button ID="Button4" runat="server" CssClass="btn btn-primary loading" Text="Update"
                                OnClick="btnUpdateProduct_Click" />
                            &nbsp;
                        <asp:Button ID="Button5" runat="server" CssClass="btn btn-primary loading" Text="Cancel" data-dismiss="modal" />
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="divDiscount" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="H3">Discount</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-xs-12 col-md-12">
                                <asp:Label ID="lblDiscountError" ForeColor="Red" runat="server" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-md-3 col-sm-3 ">Discount Type:</div>
                            <div class="col-xs-12 col-md-9 col-sm-9">
                                <asp:DropDownList ID="ddlDiscountType" runat="server" CssClass="listbox" Width="150px">
                                    <asp:ListItem Selected="true" Value="0" Text="-- Please Select --" />
                                    <asp:ListItem Value="Dollar" Text="Dollar" />
                                    <asp:ListItem Value="Percentage" Text="Percentage" />
                                </asp:DropDownList>
                            </div>
                        </div>
                        <br />
                        <div class="row">
                            <div class="col-xs-12 col-md-3 col-sm-3 ">Discount</div>
                            <div class="col-xs-12 col-md-9 col-sm-9">
                                <asp:TextBox runat="server" ID="txtDiscountValue" CssClass="textbox number" MaxLength="6" Width="80px" />
                            </div>
                        </div>
                        <br />
                        <div class="modal-footer">
                            <asp:Button ID="btnApplyDiscount" runat="server" CssClass="btn btn-primary loading" Text="Apply"
                                OnClick="btnApplyDiscount_Click" />
                            &nbsp;
                                        <asp:Button ID="btnDiscountCancel" runat="server" CssClass="btn btn-primary loading" Text="Cancel" data-dismiss="modal" />
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="divCustomer" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="H5">Customer</h4>
                    </div>
                    <div class="modal-body">
                        <ul class="nav nav-tabs" data-tabs="tabs" id="customertabs">
                            <li class="active"><a data-toggle="tab" href="#newcustomer">New</a></li>
                            <li><a data-toggle="tab" href="#oldcustomer">Returning</a></li>
                        </ul>

                        <div class="tab-content responsive">
                            <div id="newcustomer" class="tab-pane active" style="padding-top: 20px;">
                                <table class="table">
                                    <tr>
                                        <td colspan="2">
                                            <asp:Label ID="lblCError" ForeColor="Red" runat="server" />
                                            <asp:HiddenField runat="server" ID="hdSelectedUser" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Salutation:</td>
                                        <td>
                                            <asp:DropDownList ID="ddlSalutation" runat="server" CssClass="listbox" TabIndex="0">
                                                <asp:ListItem Selected="true" Value="0" Text="-- Please Select --" />
                                                <asp:ListItem Value="Mr" Text="Mr" />
                                                <asp:ListItem Value="Mrs" Text="Mrs" />
                                                <asp:ListItem Value="Miss" Text="Miss" />
                                                <asp:ListItem Value="Ms" Text="Ms" />
                                                <asp:ListItem Value="Prof" Text="Prof" />
                                                <asp:ListItem Value="Rev" Text="Rev" />
                                                <asp:ListItem Value="Other" Text="Other" />
                                            </asp:DropDownList>
                                        </td>
                                        <td>Address2:</td>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtAddress2" CssClass="textbox" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>First Name:</td>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtFirstName" CssClass="textbox" TabIndex="1" /></td>

                                        <td>City:</td>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtCity" CssClass="textbox" /></td>

                                    </tr>
                                    <tr>
                                        <td>Last Name:</td>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtLastName" CssClass="textbox" TabIndex="2" /></td>
                                        <td>State:</td>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtState" CssClass="textbox" /></td>

                                    </tr>
                                    <tr>
                                        <td>Email:</td>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtEmail" CssClass="textbox" TabIndex="3" /></td>

                                        <td>Country:</td>
                                        <td>
                                            <asp:DropDownList runat="server" ID="ddlCountry" CssClass="listbox" Width="150px" /></td>

                                    </tr>
                                    <tr>
                                        <td>Mobile:</td>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtMobileNo" CssClass="textbox" TabIndex="4" /></td>
                                        <td>Postal Code:</td>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtPostalCode" CssClass="textbox number" Width="100px" /></td>

                                    </tr>
                                    <tr>
                                        <td>Phone:</td>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtPhoneNo" CssClass="textbox" TabIndex="5" /></td>
                                    </tr>
                                    <tr>
                                        <td>Address1:</td>
                                        <td>
                                            <asp:TextBox runat="server" ID="txtAddress1" CssClass="textbox" TabIndex="6" /></td>
                                    </tr>
                                    <tr class="text-center">
                                        <td colspan="4">
                                            <asp:Button ID="btnSaveCustomer" runat="server" CssClass="btn btn-primary loading" Text="Apply"
                                                OnClick="btnSaveCustomer_Click" />
                                            &nbsp;
                                            <asp:Button ID="Button6" runat="server" CssClass="btn btn-primary loading" Text="Cancel" data-dismiss="modal" />&nbsp;
                                <asp:Button ID="btnResetCustomer" runat="server" CssClass="btn btn-primary loading" Text="Clear Selected Customer" OnClick="btnResetCustomer_Click" /></td>
                                    </tr>
                                </table>
                            </div>
                            <div id="oldcustomer" class="tab-pane" style="overflow-y: auto; max-height: 400px;">
                                <div class="table-responsive">
                                    <asp:GridView runat="server" ID="grdCustomers" CssClass="table" BorderWidth="0" GridLines="None"
                                        AutoGenerateColumns="false">
                                        <Columns>
                                            <asp:TemplateField>
                                                <ItemTemplate>
                                                    <asp:LinkButton ID="lnkSelect" runat="server" CssClass="btn btn-primary loading" OnClick="lnkSelect_Click" CommandArgument='<%# Eval("UniqueID")%>'>Select</asp:LinkButton>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <%--<asp:BoundField HeaderText="Company" DataField="CompanyName" />--%>
                                            <asp:BoundField HeaderText="First Name" DataField="FirstName" />
                                            <asp:BoundField HeaderText="Last Name" DataField="LastName" />
                                            <asp:BoundField HeaderText="Email" DataField="Email" />
                                            <asp:BoundField HeaderText="Mobile" DataField="MobileNo" />
                                            <asp:TemplateField>
                                                <ItemTemplate>
                                                    <asp:Button runat="server" data-CustomerID='<%# Eval("UniqueID") %>' Text="Delete" CssClass="btn-danger btn" ID="btnDeleteCustomer" OnClick="btnDeleteCustomer_Click" />
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                        </Columns>
                                        <EmptyDataRowStyle />
                                        <EmptyDataTemplate>
                                            No Record found
                                        </EmptyDataTemplate>
                                        <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                                    </asp:GridView>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="divMessage" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="H6"></h4>
                    </div>
                    <div class="modal-body">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="divOrderSuccess" tabindex="-1" role="dialog" aria-labelledby="Order Success" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="H10">Order Success!</h4>
                    </div>
                    <div class="modal-body">
                        The order is successfully processed! Click 'OK' to start a new order.
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" onclick="window.location.href='QuotationPOS.aspx'" data-dismiss="modal">OK </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="divConfirmation" tabindex="-1" role="dialog" aria-labelledby="Confirm Deletion" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="H4">Confirm Delete?</h4>
                    </div>
                    <div class="modal-body">
                        Are you sure want to delete the item from Shopping Cart?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" id="btnYes" onclick="ConfirmDelete();">Yes </button>
                        <button type="button" class="btn btn-danger" data-dismiss="modal">No </button>
                    </div>
                </div>
            </div>
        </div>
        

        <!-- /container -->
        <!-- Bootstrap core JavaScript
        ================================================== -->
        <!-- Placed at the end of the document so the pages load faster -->
        <script src="../Scripts/jquery.min.js"></script>
        <script src="../Scripts/vendor/bootstrap/bootstrap.min.js"></script>
        <script>
            var CurrentProduct;
            var Tax;

            function PrintReceipt(){
                window.open('Receipt.aspx', '_blank');
                }
            function SendToKitchen() {
                window.open('SendToKitchen.aspx', '_blank');
            }
            function parseFloat2(str, str1) {
                var val1 = parseFloat(str).toFixed(2);
                val1 = str1 + val1;
                return val1;
            }

            function ShowAll() {
                $('.product-envelope .products-row').show();
                $('.product-envelope .products-grid-row').show();
            }
            function ClearSearch() {
                $('#<%= txtSearch.ClientID %>').val('');
                $('#<%= txtSearch.ClientID %>').keyup();
            }

            function SearchProduct() {
                var Keyword = $('#<%= txtSearch.ClientID %>').val();
                if (Keyword != '') {
                    $('.products-row span').each(function () {
                        if ($(this).text().toLowerCase().indexOf(Keyword.toLowerCase()) != -1) {
                            $(this).parents('.products-row').show();
                        }
                        else {
                            $(this).parents('.products-row').hide();
                        }
                    });
                }
                else {
                    $('.products-row').show();
                }
            }

            function LoadItems(categoryID) {
                //$('#divItems div.pos-product img').each(function(){
                $('.product-envelope a').each(function () {
                    if ($(this).attr('data-category') != categoryID) {
                        //$(this).parent('div.pos-product').hide();
                        $(this).parents('.products-row').hide();
                        $(this).parents('.products-grid-row').hide();

                    }
                    else {
                        //$(this).parent('div.pos-product').show();
                        $(this).parents('.products-row').show();
                        $(this).parents('.products-grid-row').show();
                    }
                });
            }

            $(window).resize(function () {
                $('#divItems').height($(window).height() * 0.8);
                $('#divItems').css('overflow-y', 'scroll');
                $('div.pos-cart-scroll').css('max-height', $(window).height() * 0.4);
            });

            $(document).ready(function () {
                if (localStorage.getItem('ProductView') != null) {
                    if (localStorage.getItem('ProductView') == 'Grid') {
                        ShowList(false);
                    }
                    else {
                        ShowList(true);
                    }
                }
                else
                    {
                    ShowList(false);
                    }
                $('#divItems').height($(window).height() * 0.8);
                $('#divItems').css('overflow-y', 'scroll');
                $('div.pos-cart-scroll').css('max-height', $(window).height() * 0.4);
                $('#imgloader').hide();
                $('#lblNumberofItems').text('0');

                AZVIC.Ei8htPOS.WebUI.Admin.WebService.AzvicService.ReturnAllProducts(OnSuccess, OnFailure);

            });

            function ShowList(flag) {
                if (flag) {
                    $('.pos-product-grid').hide();
                    $('.pos-product-list').show();
                    DefaultView = 'List';
                }
                else {
                    $('.pos-product-grid').show();
                    $('.pos-product-list').hide();
                    DefaultView = 'Grid';
                }
                localStorage.setItem('ProductView', DefaultView);
            }

            function OpenDiscount() {
                $('#divDiscount').modal('show');
            }

            function ShowSelectTax() {
                $('#divSelectTax').modal({ keyboard: false, backdrop: 'static', show: 'true' });
                $('#divSelectTax button').hide();
            }
            function ShowSelectTable() {
                $('#divSelectTable').modal({ keyboard: false, backdrop: 'static', show: 'true' });
                //$('#divSelectTable button').hide();
            }
            function OpenProduct(productID) {
                var ProductLink = $('#ShoppingCartTable a[data-prodid=' + productID + ']');
                var ActualPrice = $(ProductLink).parent().siblings('td.pos-tblPrice').find('#spnPrice').text();
                var DiscountedPrice = $(ProductLink).parent().siblings('td.pos-tblPrice').find('#spnDiscountedPrice').text();
                var DiscountValue = parseFloat2($(ProductLink).parent().siblings('td.pos-tblPrice').find('#spnDiscountedPrice').attr('data-discountval'), '');
                var DiscountType = 'Percentage';
                if (DiscountValue != undefined && DiscountValue != 0) {
                    DiscountType = $(ProductLink).parent().siblings('td.pos-tblPrice').find('#spnDiscountedPrice').attr('data-discounttype');
                    DiscountType = DiscountType == null ? 'Percentage' : DiscountType;
                }
                else {
                    DiscountValue = 0;
                }
                $('#divProduct h4.modal-title').text($(ProductLink).text());
                $('#<%= txtPrice.ClientID %>').val($(ProductLink).parent().siblings('td.pos-tblPrice').find('#spnPrice').text());
                $('#<%= hdProductID.ClientID %>').val(productID);
                $('#<%= txtDiscount.ClientID %>').val(DiscountValue);
                $('#<%= ddlDiscountType.ClientID %>').val(DiscountType);
                $('#divProduct').modal('show');
                //Add the Product Tutorial.
            }

            function OnSuccess(result) {
                for (var i = 0; i < result.length; i++) {
                    var IsProdDiscounted = (result[i].DiscountValue != undefined && result[i].DiscountValue != 0) ? true : false;
                    var IsDollarDiscount = result[i].DiscountType != undefined && result[i].DiscountType == 'Dollar' ? true : false;
                    var IsPriceChanged = (result[i].OrderPrice - result[i].UnitPrice) != parseInt(0, 2) ? true : false;
                    var DiscountedUnitPrice, UnitPrice, DiscountedTotalPrice, TotalPrice;
                    
                    if (IsPriceChanged) {
                        UnitPrice = result[i].OrderPrice;
                        TotalPrice = result[i].OrderPrice * result[i].Quantity;
                    }
                    else {
                        UnitPrice = result[i].UnitPrice;
                        TotalPrice = result[i].UnitPrice * result[i].Quantity;
                    }

                    if (IsProdDiscounted) {
                        DiscountedUnitPrice = IsDollarDiscount ? UnitPrice - result[i].DiscountValue : UnitPrice - UnitPrice * (result[i].DiscountValue / 100);
                    }
                    else {
                        DiscountedUnitPrice = UnitPrice;
                    }

                    DiscountedTotalPrice = DiscountedUnitPrice * result[i].Quantity;

                    var tblName = '<td class="pos-tblName"><a class="anchor" onclick="OpenProduct(\'' + result[i].ProductID + '\')" data-prodid="' + result[i].ProductID + '">' + result[i].ProductName + '</a></td>';
                    var tblQty = '<td align="left" class="pos-tblQty"><input type="text" onkeypress="return isNumber(event)" onblur="UpdateQty(this);" name="txtItemQty" class="textbox number" style="width:50px;color:black;" value="' +
                        result[i].Quantity + '"></input><img src="../Images/Loading_cafe.gif" style="display:none;" /></td>';

                    var tblUnitPrice = '<td align="right" class="pos-tblPrice"><span data-discountval="' + result[i].DiscountValue + '" data-discounttype="' + result[i].DiscountType + '" id="spnDiscountedPrice"' + (!IsProdDiscounted ? ' class="dnone"' : '') + '>' + parseFloat2(DiscountedUnitPrice, '') +
                    '</span><span id="spnPrice"' + (IsProdDiscounted ? ' class="dstrike"' : '') + '>' + parseFloat2(UnitPrice, '') + '</td>';


                    var tblTotalPrice = '<td align="right" class="pos-tblTotal"><span id="spnDiscountedTotalPrice"' + (!IsProdDiscounted ? ' class="dnone"' : '') + '>' + parseFloat2(DiscountedTotalPrice, '') +
                    '</span><span id="spnTotalPrice"' + (IsProdDiscounted ? ' class="dstrike"' : '') + '>' + parseFloat2(TotalPrice, '') + '</td>';
                    var tblDeleteIcon = '<td align="center"><a class="fa fa-times-circle-o fa-2x anchor" href="#" onclick="DeleteConfirmation(\'' + result[i].ProductID + '\');" /> </td>';

                    var NewRow = '<tr>' + tblName + tblQty + tblUnitPrice + tblTotalPrice + tblDeleteIcon + '</tr>';

                    $('#ShoppingCartTable tbody').append(NewRow);
                }
                UpdateShoppingCart();
            }

            function UpdateBalance(evt) {
                //if (isDecimal(evt)) {
                $('#lblBalanceAmount').text(parseFloat2(parseFloat($('#<%= txtPaidAmount.ClientID %>').val()) - parseFloat($('#lblPayTotal').text().replace('SGD', '')), 'SGD '));
                //    }
                //else
                //    {
                //    return false;
                //    }
            }
            function isDecimal(evt) {
                evt = (evt) ? evt : window.event;
                var charCode = (evt.which) ? evt.which : evt.keyCode;
                if ((charCode > 31 && (charCode < 48 || charCode > 57)) && charCode != 46) {
                    return false;
                }
                return true;
            }
            function isNumber(evt) {
                evt = (evt) ? evt : window.event;
                var charCode = (evt.which) ? evt.which : evt.keyCode;
                if (charCode > 31 && (charCode < 48 || charCode > 57)) {
                    return false;
                }
                return true;
            }

            function AddProduct(productID) {
                $('#imgloader').show();
                if ($('#<%= hdnTableName.ClientID %>').val() != '') {
                    $('#<%= hdnProductSize.ClientID %>').val(productID);
                    $('#<%= btnOpenSelectSize.ClientID %>').click();
                }
                else {
                    $('#divSelectTable').modal('show');
                }
            }

            function AddProductToCart(productID) {
                $('#ShoppingCartTable tbody').find('td.pos-tblName a').each(function () {
                    if ($(this).attr('data-prodid') == productID) {
                        $(this).parents('tr').remove();
                    }
                });
                AZVIC.Ei8htPOS.WebUI.Admin.WebService.AzvicService.AddProduct(productID, 1, 'A', OnSuccessAdded, OnFailure);
            }

            function OnSuccessAdded(result) {

                var IsProdDiscounted = (result.DiscountValue != undefined && result.DiscountValue != 0) ? true : false;
                var IsDollarDiscount = result.DiscountType != undefined && result.DiscountType == 'Dollar' ? true : false;
                var IsPriceChanged = (result.OrderPrice - result.UnitPrice) != parseInt(0, 2) ? true : false;
                var DiscountedUnitPrice, UnitPrice, DiscountedTotalPrice, TotalPrice;
                if (IsPriceChanged) {
                    UnitPrice = result.OrderPrice;
                    TotalPrice = result.OrderPrice * result.Quantity;
                }
                else {
                    UnitPrice = result.UnitPrice;
                    TotalPrice = result.UnitPrice * result.Quantity;
                }

                if (IsProdDiscounted) {
                    DiscountedUnitPrice = IsDollarDiscount ? UnitPrice - result.DiscountValue : UnitPrice - UnitPrice * (result.DiscountValue / 100);
                }
                else {
                    DiscountedUnitPrice = UnitPrice;
                }

                DiscountedTotalPrice = DiscountedUnitPrice * result.Quantity;

                var tblName = '<td class="pos-tblName"><a class="anchor" onclick="OpenProduct(\'' + result.ProductID + '\')" data-prodid="' + result.ProductID + '">' + result.ProductName + '</a></td>';
                var tblQty = '<td align="left" class="pos-tblQty"><input type="text" onkeypress="return isNumber(event)" onblur="UpdateQty(this);" name="txtItemQty" class="textbox number" style="width:50px;color:black;" value="' +
                    result.Quantity + '"></input><img src="../Images/Loading_cafe.gif" style="display:none;" /></td>';

                var tblUnitPrice = '<td align="right" class="pos-tblPrice"><span data-discountval="' + result.DiscountValue + '" data-discounttype="' + result.DiscountType + '" id="spnDiscountedPrice"' + (!IsProdDiscounted ? ' class="dnone"' : '') + '>' + parseFloat2(DiscountedUnitPrice, '') +
                '</span><span id="spnPrice"' + (IsProdDiscounted ? ' class="dstrike"' : '') + '>' + parseFloat2(UnitPrice, '') + '</td>';


                var tblTotalPrice = '<td align="right" class="pos-tblTotal"><span id="spnDiscountedTotalPrice"' + (!IsProdDiscounted ? ' class="dnone"' : '') + '>' + parseFloat2(DiscountedTotalPrice, '') +
                '</span><span id="spnTotalPrice"' + (IsProdDiscounted ? ' class="dstrike"' : '') + '>' + parseFloat2(TotalPrice, '') + '</td>';
                var tblDeleteIcon = '<td align="center"><a class="fa fa-times-circle-o fa-2x anchor" href="#" onclick="DeleteConfirmation(\'' + result.ProductID + '\');" /> </td>';

                var NewRow = '<tr>' + tblName + tblQty + tblUnitPrice + tblTotalPrice + tblDeleteIcon + '</tr>';

                $('#ShoppingCartTable tbody').append(NewRow);
                UpdateShoppingCart();
                $('#imgloader').hide();
            }

            function UpdateShoppingCart() {
                AZVIC.Ei8htPOS.WebUI.Admin.WebService.AzvicService.ReturnOrderDetails(OnSuccessUpdated, OnFailure);
            }



            function OnSuccessUpdated(result) {
                $('#lblNumberofItems').text(result.OrdersDetailsList.length);
                $('#lblSubTotal').text(parseFloat2(result.SubTotal, 'SGD '));
                $('#lblDiscount').text(parseFloat2(result.Discount + result.TotalDiscount + result.HappyHoursDiscount, 'SGD '));
                $('#lblTax').text(parseFloat2(result.GST + result.ServiceTax, 'SGD '));
                //$('#lblGST').text(parseFloat2(result.GST, 'SGD '));
                $('#lblTotal').text(parseFloat2(result.Total, 'SGD '));
                //$('#lblTotalPayment').text('Pay SGD ' + parseFloat2(result.Total,''));

            }

            function UpdateQty(product) {
                var newQty = $(product).val();
                var productID = $(product).parent().siblings('td.pos-tblName').find('a').attr('data-prodid');
                if (parseInt(newQty, 10) != 0) {
                    $(product).siblings('img').show();
                    AZVIC.Ei8htPOS.WebUI.Admin.WebService.AzvicService.AddProduct(productID, newQty, 'U', OnSuccessQtyUpdated, OnFailure);
                }
                else {
                    CurrentProduct = productID;
                    ConfirmDelete();
                }
            }
            function OnSuccessQtyUpdated(result) {
                $('#ShoppingCartTable td a[data-prodid=' + result.ProductID + ']').parents('td').siblings('.pos-tblTotal').find('#spnTotalPrice').text(parseFloat2(result.UnitPrice * result.Quantity, ''));
                $('#ShoppingCartTable td a[data-prodid=' + result.ProductID + ']').parents('td').siblings('.pos-tblTotal').find('#spnDiscountedTotalPrice').text(parseFloat2(result.OrderPrice * result.Quantity, ''));
                $('#ShoppingCartTable td a[data-prodid=' + result.ProductID + ']').parents('td').siblings('.pos-tblQty').find('img').hide();
                UpdateShoppingCart();
            }


            function DeleteConfirmation(productID) {

                $('#divConfirmation').modal({
                    backdrop: 'static'
                });
                CurrentProduct = productID;
            }

            function ConfirmDelete() {
                $('#divConfirmation').modal('hide');
                $('#ShoppingCartTable tbody').find('td.pos-tblName a').each(function () {
                    if ($(this).attr('data-prodid') == CurrentProduct) {
                        $(this).parents('tr').remove();
                    }
                });
                $('#lblNumberofItems').text($('#ShoppingCartTable tbody tr').length);
                AZVIC.Ei8htPOS.WebUI.Admin.WebService.AzvicService.DeleteProduct(CurrentProduct, OnSuccessDeleted, OnFailure);
            }

            function OnSuccessDeleted() {
                UpdateShoppingCart();
            }

            function OnFailure(error) {
                ShowAlert(error.message, 'Ei8ht POS');
            }
        </script>
    </form>
</body>
</html>

